/*  */
/*     HAMEG GmbH                                                           */
/*     Sample program for Interface HO79-2, HO79-3                          */
/*     Communication with HAMEG Digital/Analog Storage Scopes               */
/*     Supported commands : "ID?", "DIG", "GET"                             */
/*                                                                          */
/*     According to the desired memory model link with one of the           */
/*     folllowing files:                                                    */
/*        cscommon.obj,         ( Model: small  )                           */
/*        cmcommon.obj,         ( Model: medium )                           */
/*        clcommon.obj.         ( Model: large  )                           */
/*                                                                          */
/*     (use 'insert' in the project environment)                            */
/*                                                                          */
/*     Please note that the device address has to be set within your        */
/*     program according to the setting at the HO79 interface               */
/*                                                                          */
/*     For compilation the following files are required                     */
/*        mc.h and                                                          */
/*        c?common.obj       ? : [s,m,l]                                    */
/*    The drivers for HO80 (IEEE-488 interface card) are supplied           */
/*    by HAMEG, other drivers can be used instead.                          */
/*                                                                          */
/* - */

/*  */
/* I/O address of the GBIP controller                                       */
/* Direct access to the SRQ line is possible by using Register 2            */

#define IO_ADR  0x2B8

/*  */
/*      Key code of bioskey() high byte                                     */

#define ESC  01

#define F1  59
#define F2  60
#define F3  61
#define F4  62
#define F10 68

/*  */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>

#include <mc.h>

/*  */

char	id[]="ID?";
char	dig[]="DIG";
char	get[]="GET";

unsigned char	data[0x2000];

/*  */

int main (void)
{
int					key;
int					pos;

int 				ieee_chef, my_address, device;
int					status, pol;
int                 anz, length, dummy;
char                cmd[80], *response;


/* Screen settings */
	textcolor(WHITE);
	textbackground(BLUE);
	clrscr();

	HO80_SEG = 0xCC00;
	if (ieee_se(HO80_SEG) != 0) {
		cprintf ("HO80 IEEE-488 not found");
		return (2);
	}
	ieee_chef = 0;                          /*  IEEE-488 controller */
	my_address = 21;                        /*  "my" device address */
	device=0x0B;
	init (&ieee_chef,&my_address);      /* Initialisation of HO80 card */
	delay (3000);                       /* Wait for end of initialisation */
	iwd (&status, "FRM 0", &device);			/* set binary format */


/* Screen settings:
		1. : Function key bar
		2. : Data window for data received
*/

/* Function key bar */
	window(1,1,80,2);
	textcolor(YELLOW);
	textbackground(CYAN);
    clreol();
	cprintf("F1-ID?   F2-DIG   F3-GET                                          F10-EXIT");

/* wWindow for data received */
	textcolor(WHITE);
	textbackground(BLUE);
	window(1,3,80,20);


	do {
/* Key pressed ? */
/* Read code and transmit command */

		if (bioskey(1) != 0) {
			key = bioskey(0);
			switch (key>>8) {
				case F1 :
					iwd (&status, id, &device);
					response = "                                            ";
					ird (&status, &device, &anz, response);
					cprintf (" %s", response);
                	break;
				case F2 :
                    iwd (&status, dig, &device);
					sprintf (&(cmd[0]),"MLA TALK %2d",device);
					iwsd   (&status, cmd);
					length = sizeof (data);
/* HM408:   4096 data bytes + 256 parameter bytes */
/* HM205-3: 4096 Data bytes +   0 Parameter bytes */
					anz = 0;
					irda (&status, (int*)&anz, &length, &(data[0]), &dummy);
        			for (pos=0; pos<anz; pos++)
						cprintf ("%c", data[pos]);
                    break;
				case F3 :
                    iwd (&status, get, &device);
					while ((inport(IO_ADR+2)&0x40)==0x00);
					ispl (&status, &pol, &device);
					sprintf (&(cmd[0]),"MLA TALK %2d",device);
					iwsd   (&status, cmd);
					length = sizeof (data);
/* HM408:   4096 Data bytes + 256 parameter bytes */
/* HM205-3: 4096 Data bytes +   0 parameter bytes */
					anz = 0;
					irda (&status, (int*)&anz, &length, &(data[0]), &dummy);
        			for (pos=0; pos<anz; pos++)
						cprintf ("%c", data[pos]);
                	break;
			}
		}
/* Terminate program on pushing ESC or F10 */
	} while (((key>>8)!=F10) && ((key>>8)!=ESC));
	return (0);
}

/*  */

